#!/bin/sh

debian_install(){
	sudo apt-get install curl -y
	curl -s https://packagecloud.io/install/repositories/ookla/speedtest-cli/script.deb.sh | sudo bash
	sudo apt-get install speedtest -y
}

redhat_install(){
	sudo yum install curl -y
	curl -s https://install.speedtest.net/app/cli/install.rpm.sh | sudo bash
	sudo yum install speedtest -y
}

# 判断系统类型
os_type=''
if [ -f /etc/debian_version ]; then
   os_type='debian'
elif [ -f /etc/redhat-release ]; then
   os_type='redhat'
else
   echo "Unsupported OS"
   exit;
fi

if [ $os_type == 'debian' ]; then
	debian_install
elif [ $os_type == 'redhat' ]; then
	redhat_install
else
	echo "Unsupported OS"
	exit;
fi